 ; Ŀ
 ;   Pedo - Plot to postscript for the manufacture of PDF files.           
 ;   Copyright 2001, 2002, 2003, 2004, 2010 by Rocket Software Ltd.        
 ;   This thing is very unproven.                                          
 ; 

 ; Ŀ
 ;   Fisp - find out which space the title block occupies.                 
 ;   Takes no arguments, returns either "Model" or "Paper", indicating     
 ;   the space to plot.                                                    
 ;   Revised 2010.02.18: may also return None if no tb is found.           
 ;   Contains an internal list of blocks, if any one is found in the       
 ;   drawing then the space it occupies is taken as the one to plot.       
 ;   No provision is made for choosing between multiple paper space        
 ;   layouts.                                                              
 ; 
 (DEFUN FISP (/ tblist blnam ss enam space prisp)
  (setq tblist '("icaltblk" "d-bord-e" "TRIDYNE_TB_D" "gca1tb" "geielctb"
                 "Husky_A1" "a1b" "D-GEN-L" "T2A-3" "IFCDATE1" "IFCDATE2"
                 "IFCDATE3" "IFCDATE4" "horz_2dborda1" "Marathontb"
                 "RWTitleBlock" "PPC-Dsize"))
  (while (and (setq blnam (car tblist))
              (or (null (tblsearch "block" blnam))
                  (null (setq ss (ssget "x" (list (cons 2 blnam)))))))
         (setq tblist (cdr tblist)))
  (cond ((null ss)
         (setq prisp "None"))
        ((and (setq enam (ssname ss 0))
              (setq space (cdr (assoc 67 (entget enam))))
              (= space 1))
         (setq prisp "Paper"))
        (T
         (setq prisp "Model")))
 prisp)
 ; Ŀ
 ;   Fisp end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Nplot - plot 11 x 17 in model space.                       
 ;   Takes no arguments, returns nothing, calls nothing.                   
 ; 
 (DEFUN NPLOT (dwgname)
  (command "-plot")
  (command "y")                               ; detailed plot configuration?
  (command "Model")                           ; layout name <Model>:
  (command "PostScript Level 2.pc3")          ; output device name
  (command "ANSI B (11.00 x 17.00 Inches)")   ; paper size
  (command "Millimeters")                     ; paper units
  (command "Landscape")                       ; dwg orientation
  (command "N")                               ; plot upside down?
  (command "Extents")                         ; plot area
  (command "Fit")                             ; plot scale
  (command "Center")                          ; plot offset
  (command "Yes")                             ; plot with plot styles?
  (command "TRIDYNE BLACK B.ctb")             ; plot style table (. for none)
  (command "Y")                               ; plot with lineweights?
  (command "N")                               ; remove hidden lines?
  (command "Y")                               ; plot to a file?
  (command (strcat "T:\\CADD\\Distill\\in\\" dwgname))  ; file name
  (command "N")                               ; Save changes to model tab?
  (command "Y")                               ; Proceed with plot?
 (princ))
 ; Ŀ
 ;   Subroutine Nplot end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Pplot - plot 11 x 17 in paper space.                       
 ;   Takes no arguments, returns nothing, calls nothing.                   
 ; 
 (DEFUN PPLOT (dwgname)
  (command "-plot")
  (command "y")                               ; detailed plot configuration?
  (command "")                                ; layout name or [?] <Layout1>
  (command "PostScript Level 2.pc3")          ; output device name
  (command "ANSI B (11.00 x 17.00 Inches)")   ; paper size
  (command "Millimeters")                     ; paper units
  (command "Landscape")                       ; dwg orientation
  (command "N")                               ; plot upside down?
  (command "Extents")                         ; plot area
  (command "Fit")                             ; plot scale
  (command "Center")                          ; plot offset
  (command "Yes")                             ; plot with plot styles?
  (command "TRIDYNE BLACK B.ctb")             ; plot style table (. for none)
  (command "Y")                               ; plot with lineweights?
  (command "N")                               ; Scale linewgts with plot scale?
  (command "N")                               ; Plot paper space first?
  (command "N")                               ; remove hidden lines?
  (command "Y")                               ; plot to a file?
  (command (strcat "t:\\cadd\\Distill\\in\\" dwgname))  ; file name
  (command "Y")                               ; Save changes to layout?
  (command "Y")                               ; Proceed with plot?
 (princ))
 ; Ŀ
 ;   Subroutine Pplot end.                                                 
 ; 

 ; Ŀ
 ;   Pedo.                                                                 
 ; 
 (DEFUN C:PEDO (/ dwgnam spac)
  (setvar "cmdecho" 1)
  (setq dwgnam (strcase (getvar "dwgname")))
  (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
         (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
  (setq spac (fisp))
  (cond ((= "Model" spac)
         (setvar "tilemode" 1)
         (nplot dwgnam))
        ((= "Paper" spac)
         (setvar "tilemode" 0)
         (pplot dwgnam))
        ((= "None" spac)
         (if (= (getvar "tilemode") 1)
             (nplot dwgnam)
             (pplot dwgnam))))
 (princ))